;***********************************************************************************************************************
;*   MACRO.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;* 150214-02
;***********************************************************************************************************************
.MACRO  SAVE_SREG                       ;   SREG      
        in      r15,SREG
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  LOAD_SREG                       ;   SREG
        out     SREG,r15
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  CLR_SEGA_SYN                    ;       0   SEGA 
        cbi     PORTD,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  SET_SEGA_SYN                    ;   1   SEGA 
        sbi     PORTD,4
.ENDMACRO

;***********************************************************************************************************************
;* 150214-01                                -
;***********************************************************************************************************************
.MACRO  INIT_PORTS                      ;    -:

        ldi     temp_m,0b00111000       ; PORTB:
        out     DDRB,temp_m
                                        ; PB7 -   -   ()
                                        ; PB6 -   -   ()
                                        ; PB5 -  - REG_SHIFT -      
                                        ; PB4 -  - REG_DATA  -      
                                        ; PB3 -  - REG_LATCH -    
                                        ; PB2 -   - SEGA1_4   - 1 SEGA  4 
                                        ; PB1 -   - SEGA1_2   - 1 SEGA  2 
                                        ; PB0 -   - SEGA1_1   - 1 SEGA  1 

        ldi     temp_m,0b00000000       ; PORTC:
        out     DDRC,temp_m
                                        ; PC7 -   - 
                                        ; PC6 -   -   (RESET)
                                        ; PC5 -   - SEGA2_6   - 2 SEGA  6 
                                        ; PC4 -   - SEGA2_2   - 2 SEGA  2 
                                        ; PC3 -   - SEGA2_1   - 2 SEGA  1 
                                        ; PC2 -   - SEGA2_3   - 2 SEGA  3 
                                        ; PC1 -   - SEGA2_4   - 2 SEGA  4 
                                        ; PC0 -   - SEGA2_9   - 2 SEGA  9 

        ldi     temp_m,0b00010010       ; PORTD:
        out     DDRD,temp_m
                                        ; PD7 -   - SEGA1_3   - 1 SEGA  3 
                                        ; PD6 -   - SEGA1_9   - 1 SEGA  9 
                                        ; PD5 -   - SEGA1_6   - 1 SEGA  6 
                                        ; PD4 -  - SEGA12_7  - 1  2 SEGA  7  - 
                                        ; PD3 -   - KEYB_CLK  -  PS2 ,     !!!
                                        ; PD2 -   - KEYB_DATA -    PS2 ,     !!!
                                        ; PD1 -  - TX - ,   UART
                                        ; PD0 -   - RX - ,     UART
.ENDMACRO

;***********************************************************************************************************************
;* 150214-02                                   
;***********************************************************************************************************************

.MACRO  CLR_REG_DATA                    ;       0     
        cbi     PORTB,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  SET_REG_DATA                    ;   1     
        sbi     PORTB,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  CLR_REG_SHIFT                   ;       0     
        cbi     PORTB,5
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  SET_REG_SHIFT                   ;   1     
        sbi     PORTB,5
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  CLR_REG_LATCH                   ;       0     
        cbi     PORTB,3
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  SET_REG_LATCH                   ;   1     
        sbi     PORTB,3
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  SHIFT_KEY_TO_REGS               ;         
        cbi     PORTB,4                 ; CLR_REG_DATA  ;       = 0

        ld      temp_m,y+               ;      ,    
        sbrc    temp_m,0                ;      -     ?

        sbi     PORTB,4                 ; SET_REG_DATA  ;   -        1

        sbi     PORTB,5                 ; SET_REG_SHIFT ;      
        cbi     PORTB,5                 ; CLR_REG_SHIFT
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  SHIFT_REGS                      ;   
        sbi     PORTB,5                 ; SET_REG_SHIFT
        cbi     PORTB,5                 ; CLR_REG_SHIFT
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  LATCH_REGS                      ;         
        sbi     PORTB,3                 ; SET_REG_LATCH
        cbi     PORTB,3                 ; CLR_REG_LATCH
.ENDMACRO

;***********************************************************************************************************************





